% Script charginette_r_v_zh_kn_10_12_no_pot.m
% Traage de surface caractrisant Une charginette.
% utilise x une liste de valeurs relles correspondant
%  la longueur r sparant les deux charges lectriques.
% y une liste de valeurs relles correspondant  la vitesse v
% z la valeur de le la charge neutre d'un lectron de la charginette
% il n'y a pas d'argment en entre
% la sortie est une graphique 3D
kex = sym(8.987551787);
ex = sym(1.602176565);
cx = sym(2.99752458);
zh = sym(9.109382);
%xx = [0.001:0.001:0.10];
xx = [0.08:0.08:8.0];
yy = [0.1:0.1:10];
%yy = [0.01:0.01:1.0];
[x,y] = meshgrid(xx, yy);
dingx = kex * ex^sym(2) .* x;
daox = zh^sym(2);
parenthese = (sym(10) ./ y.^sym(2));
D1num = sym(5) .* dingx;
D1den = sym(2) .* daox;
y10 = D1num .* parenthese ./ D1den;
surf(x, y, double(vpa(y10)))
title('Caracteristic of Charginette')
xlabel('zh = x * E(-31) kg')
ylabel('v = y * E(2) meter/second')
zlabel('r = z * E(-15) meter')

